# Characters

| Preview                                                            | Firmware Variable          | Configurator Variable        | Description                           | Decimal ID | HEX ID       |
|--------------------------------------------------------------------|----------------------------|------------------------------|---------------------------------------|------------|--------------|
| ![None](/resources/osd/digital/default/24x36/000.png)              | SYM_NONE                   |                              | Completely transparent icon           | 000        | 0x00         |
| ![RSSI](/resources/osd/digital/default/24x36/001.png)              | SYM_RSSI                   | SYM.RSSI                     | RSSI Icon                             | 001        | 0x01         |
| ![LQ](/resources/osd/digital/default/24x36/002.png)                | SYM_LQ                     | SYM.LQ                       | LQ Icon                               | 002        | 0x02         |
| ![Latitude](/resources/osd/digital/default/24x36/003.png)          | SYM_LAT                    | SYM.LAT                      | Latitude                              | 003        | 0x03         |
| ![Longitude](/resources/osd/digital/default/24x36/004.png)         | SYM_LON                    | SYM.LON                      | Longitude                             | 004        | 0x04         |
| ![Azimuth](/resources/osd/digital/default/24x36/005.png)           | SYM_AZIMUTH                | SYM.AZIMUTH                  | Azimuth                               | 005        | 0x05         |
| ![Telemetry](/resources/osd/digital/default/24x36/006.png)         | SYM_TELEMETRY_0            |                              | Antenna tracking Telemetry            | 006        | 0x06         |
| ![Telemetry](/resources/osd/digital/default/24x36/007.png)         | SYM_TELEMETRY_1            |                              | Antenna tracking Telemetry            | 007        | 0x07         |
| ![Satellites](/resources/osd/digital/default/24x36/008-009.png)    | SYM_SAT_L                  | SYM.GPS_SAT1                 | Satellites Icon, left side            | 008        | 0x08         |
|                                                                    | SYM_SAT_R                  | SYM.GPS_SAT2                 | Satellites Icon, right side           | 009        | 0x09         |
| ![Near Home](/resources/osd/digital/default/24x36/010.png)         | SYM_HOME_NEAR              |                              | Icon shown at home point              | 010        | 0x0A         |
| ![Degrees](/resources/osd/digital/default/24x36/011.png)           | SYM_DEGREES                | SYM.DEGREES                  | Degree symbol                         | 011        | 0x0B         |
| ![Heading](/resources/osd/digital/default/24x36/012.png)           | SYM_HEADING                | SYM.HEADING                  | Heading symbol                        | 012        | 0x0C         |
| ![Map Scale](/resources/osd/digital/default/24x36/013.png)         | SYM_SCALE                  | SYM.SCALE                    | Map scale symbol                      | 013        | 0x0D         |
| ![HDOP](/resources/osd/digital/default/24x36/014-015.png)          | SYM_HDP_L                  | SYM.GPS_HDP1                 | HDOP icon, left side                  | 014        | 0x0E         |
|                                                                    | SYM_HDP_R                  | SYM.GPS_HDP2                 | HDOP icon, right side                 | 015        | 0x0F         |
| ![Home](/resources/osd/digital/default/24x36/016.png)              | SYM_HOME                   | SYM.HOME                     | Home icon                             | 016        | 0x10         |
| ![RSSI 2](/resources/osd/digital/default/24x36/017.png)            | SYM_2RSS                   | SYM.RSS2                     | RSSI 2 icon                           | 017        | 0x11         |
| ![Decibel](/resources/osd/digital/default/24x36/018.png)           | SYM_DB                     | SYM.DB                       | Decibel icon                          | 018        | 0x12         |
| ![Decibel per mW](/resources/osd/digital/default/24x36/019.png)    | SYM_DBM                    | SYM.DBM                      | Decibel per milliwatt icon            | 019        | 0x13         |
| ![SNR](/resources/osd/digital/default/24x36/020.png)               | SYM_SNR                    | SYM.SNR                      | Signal to Noise Ratio icon            | 020        | 0x14         |
| ![AHI up arrow](/resources/osd/digital/default/24x36/021.png)      | SYM_AH_DECORATION_UP       | SYM.AH_DECORATION_UP         | AHi up arrow                          | 021        | 0x15         |
| ![AHI down arrow](/resources/osd/digital/default/24x36/022.png)    | SYM_AH_DECORATION_DOWN     |                              | AHI down arrow                        | 022        | 0x16         |
| ![Direction](/resources/osd/digital/default/24x36/023.png)         | SYM_DECORATION             | SYM.DECORATION               | Direction little arrows               | 023 - 030  | 0x17 - 0x1E  |
| ![Direction](/resources/osd/digital/default/24x36/024.png)         |                            |                              |                                       | 024        | 0x18         |
| ![Direction](/resources/osd/digital/default/24x36/025.png)         |                            |                              |                                       | 025        | 0x19         |
| ![Direction](/resources/osd/digital/default/24x36/026.png)         |                            |                              |                                       | 026        | 0x1A         |
| ![Direction](/resources/osd/digital/default/24x36/027.png)         |                            |                              |                                       | 027        | 0x1B         |
| ![Direction](/resources/osd/digital/default/24x36/028.png)         |                            |                              |                                       | 028        | 0x1C         |
| ![Direction](/resources/osd/digital/default/24x36/029.png)         |                            |                              |                                       | 029        | 0x1D         |
| ![Direction](/resources/osd/digital/default/24x36/030.png)         |                            |                              |                                       | 030        | 0x1E         |
| ![Volts](/resources/osd/digital/default/24x36/031.png)             | SYM_VOLT                   | SYM.VOLT                     | Volts symbol                          | 031        | 0x1F         |
| ![Blank](/resources/osd/digital/default/24x36/032.png)             | SYM_BLANK _*_              | SYM.BLANK                    | Empty                                 | 032        | 0x20         |
| ![Exclamation](/resources/osd/digital/default/24x36/033.png)       | _ASCII_ _*_                |                              | !                                     | 033        | 0x21         |
| ![Ah per Km](/resources/osd/digital/default/24x36/034.png)         | SYM_AH_KM                  |                              | Ah per Km                             | 034        | 0x22         |
| ![Hash](/resources/osd/digital/default/24x36/035.png)              | _ASCII_ _*_                |                              | #                                     | 035        | 0x23         |
| ![Ah per Mile](/resources/osd/digital/default/24x36/036.png)       | SYM_AH_MI                  |                              | Ah per Mile                           | 036        | 0x24         |
| ![Percent](/resources/osd/digital/default/24x36/037.png)           | _ASCII_ _*_                |                              | %                                     | 037        | 0x25         |
| ![Ampersand](/resources/osd/digital/default/24x36/038.png)         | _ASCII_ _*_                |                              | &                                     | 038        | 0x26         |
| ![VTX Power](/resources/osd/digital/default/24x36/039.png)         | SYM_VTX_POWER              | SYM.VTX_POWER                | VTx Power                             | 039        | 0x27         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/040.png)     | _ASCII_ _*_                |                              | Symbols and numbers                   | 040 - 062  | 0x28 - 0x3E  |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/041.png)     | _ASCII_ _*_                |                              |                                       | 041        | 0x29         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/042.png)     | _ASCII_ _*_                |                              |                                       | 042        | 0x2A         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/043.png)     | _ASCII_ _*_                |                              |                                       | 043        | 0x2B         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/044.png)     | _ASCII_ _*_                |                              |                                       | 044        | 0x2C         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/045.png)     | _ASCII_ _*_                |                              |                                       | 045        | 0x2D         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/046.png)     | _ASCII_ _*_                |                              |                                       | 046        | 0x2E         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/047.png)     | _ASCII_ _*_                |                              |                                       | 047        | 0x2F         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/048.png)     | _ASCII_ _*_                |                              |                                       | 048        | 0x30         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/049.png)     | _ASCII_ _*_                |                              |                                       | 049        | 0x31         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/050.png)     | _ASCII_ _*_                |                              |                                       | 050        | 0x32         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/051.png)     | _ASCII_ _*_                |                              |                                       | 051        | 0x33         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/052.png)     | _ASCII_ _*_                |                              |                                       | 052        | 0x34         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/053.png)     | _ASCII_ _*_                |                              |                                       | 053        | 0x35         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/054.png)     | _ASCII_ _*_                |                              |                                       | 054        | 0x36         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/055.png)     | _ASCII_ _*_                |                              |                                       | 055        | 0x37         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/056.png)     | _ASCII_ _*_                |                              |                                       | 056        | 0x38         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/057.png)     | _ASCII_ _*_                |                              |                                       | 057        | 0x39         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/058.png)     | _ASCII_ _*_                |                              |                                       | 058        | 0x3A         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/059.png)     | _ASCII_ _*_                |                              |                                       | 059        | 0x3B         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/060.png)     | _ASCII_ _*_                |                              |                                       | 060        | 0x3C         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/061.png)     | _ASCII_ _*_                |                              |                                       | 061        | 0x3D         |
| ![ASCII Numbers](/resources/osd/digital/default/24x36/062.png)     | _ASCII_ _*_                |                              |                                       | 062        | 0x3E         |
| ![Ah/Nautical Mile](/resources/osd/digital/default/24x36/063.png)  | SYM_AH_NM                  | SYM.AH_NM                    | Ah per Nautical Mile                  | 063        | 0x3F         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/064.png)    | _ASCII_ _*_                |                              | Alphabet and symbols                  | 064 - 095  | 0x40 - 0x5F  |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/065.png)    | _ASCII_ _*_                |                              |                                       | 065        | 0x41         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/066.png)    | _ASCII_ _*_                |                              |                                       | 066        | 0x42         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/067.png)    | _ASCII_ _*_                |                              |                                       | 067        | 0x43         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/068.png)    | _ASCII_ _*_                |                              |                                       | 068        | 0x44         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/069.png)    | _ASCII_ _*_                |                              |                                       | 069        | 0x45         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/070.png)    | _ASCII_ _*_                |                              |                                       | 070        | 0x46         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/071.png)    | _ASCII_ _*_                |                              |                                       | 071        | 0x47         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/072.png)    | _ASCII_ _*_                |                              |                                       | 072        | 0x48         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/073.png)    | _ASCII_ _*_                |                              |                                       | 073        | 0x49         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/074.png)    | _ASCII_ _*_                |                              |                                       | 074        | 0x4A         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/075.png)    | _ASCII_ _*_                |                              |                                       | 075        | 0x4B         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/076.png)    | _ASCII_ _*_                |                              |                                       | 076        | 0x4C         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/077.png)    | _ASCII_ _*_                |                              |                                       | 077        | 0x4D         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/078.png)    | _ASCII_ _*_                |                              |                                       | 078        | 0x4E         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/079.png)    | _ASCII_ _*_                |                              |                                       | 079        | 0x4F         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/080.png)    | _ASCII_ _*_                |                              |                                       | 080        | 0x50         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/081.png)    | _ASCII_ _*_                |                              |                                       | 081        | 0x51         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/082.png)    | _ASCII_ _*_                |                              |                                       | 082        | 0x52         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/083.png)    | _ASCII_ _*_                |                              |                                       | 083        | 0x53         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/084.png)    | _ASCII_ _*_                |                              |                                       | 084        | 0x54         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/085.png)    | _ASCII_ _*_                |                              |                                       | 085        | 0x55         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/086.png)    | _ASCII_ _*_                |                              |                                       | 086        | 0x56         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/087.png)    | _ASCII_ _*_                |                              |                                       | 087        | 0x57         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/088.png)    | _ASCII_ _*_                |                              |                                       | 088        | 0x58         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/089.png)    | _ASCII_ _*_                |                              |                                       | 089        | 0x59         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/090.png)    | _ASCII_ _*_                |                              |                                       | 090        | 0x5A         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/091.png)    | _ASCII_ _*_                |                              |                                       | 091        | 0x5B         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/092.png)    | _ASCII_ _*_                |                              |                                       | 092        | 0x5C         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/093.png)    | _ASCII_ _*_                |                              |                                       | 093        | 0x5D         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/094.png)    | _ASCII_ _*_                |                              |                                       | 094        | 0x5E         |
| ![ASCII Alphabet](/resources/osd/digital/default/24x36/095.png)    | _ASCII_ _*_                |                              |                                       | 095        | 0x5F         |
| ![mAh per NM](/resources/osd/digital/default/24x36/096-097.png)    | SYM_MAH_NM_0               | SYM.MAH_NM_0                 | mAh per Nautical mile, left side      | 096        | 0x60         |
|                                                                    | SYM_MAH_NM_1               | SYM.MAH_NM_1                 | mAh per Nautical mile, right side     | 097        | 0x61         |
| ![milliOhm](/resources/osd/digital/default/24x36/098.png)          | SYM_MILLIOHM               | SYM.MILLIOHM                 | MilliOhm symbol                       | 098        | 0x62         |
| ![Battery Full](/resources/osd/digital/default/24x36/099.png)      | SYM_BATT_FULL              | SYM.BATT                     | Battery full                          | 099        | 0x63         |
| ![Battery 83%](/resources/osd/digital/default/24x36/100.png)       | SYM_BATT_5                 |                              | Battery ~83%                          | 100        | 0x64         |
| ![Battery 67%](/resources/osd/digital/default/24x36/101.png)       | SYM_BATT_4                 |                              | Battery ~67%                          | 101        | 0x65         |
| ![Battery 50%](/resources/osd/digital/default/24x36/102.png)       | SYM_BATT_3                 |                              | Battery ~50%                          | 102        | 0x66         |
| ![Battery 34%](/resources/osd/digital/default/24x36/103.png)       | SYM_BATT_2                 |                              | Battery ~34%                          | 103        | 0x67         |
| ![Battery 17%](/resources/osd/digital/default/24x36/104.png)       | SYM_BATT_1                 |                              | Battery ~17%                          | 104        | 0x68         |
| ![Battery Empty](/resources/osd/digital/default/24x36/105.png)     | SYM_BATT_EMPTY             |                              | Battery EMPTY                         | 105        | 0x69         |
| ![Amps](/resources/osd/digital/default/24x36/106.png)              | SYM_AMP                    | SYM.AMP                      | Amps symbol                           | 106        | 0x6A         |
| ![mAh per Km](/resources/osd/digital/default/24x36/107-108.png)    | SYM_MAH_KM_0               | SYM.MAH_KM_0                 | mAh per Kilometre, left side          | 107        | 0x6B         |
|                                                                    | SYM_MAH_KM_1               | SYM.MAH_KM_1                 | mAh per Kilometre, right side         | 108        | 0x6C         |
| ![Watt hours](/resources/osd/digital/default/24x36/109.png)        | SYM_WH                     | SYM.WH                       | Watthours symbol                      | 109        | 0x6D         |
| ![Wh per Km](/resources/osd/digital/default/24x36/110.png)         | SYM_WH_KM                  | SYM.WH_KM                    | Watthours per Kilometre               | 110        | 0x6E         |
| ![Wh per Mile](/resources/osd/digital/default/24x36/111.png)       | SYM_WH_MI                  | SYM.WH_MI                    | Watthours per Mile                    | 111        | 0x6F         |
| ![Wh per NM](/resources/osd/digital/default/24x36/112.png)         | SYM_WH_NM                  | SYM.WH_NM                    | Watthours per Nautical Mile           | 112        | 0x70         |
| ![Watts](/resources/osd/digital/default/24x36/113.png)             | SYM_WATT                   | SYM.WATT                     | Watts symbol                          | 113        | 0x71         |
| ![milliWatts](/resources/osd/digital/default/24x36/114.png)        | SYM_MW                     | SYM.MW                       | Milliwatts symbol                     | 114        | 0x72         |
| ![kiloWatts](/resources/osd/digital/default/24x36/115.png)         | SYM_KILOWATT               |                              | Kilowatts symbol                      | 115        | 0x73         |
| ![Feet](/resources/osd/digital/default/24x36/116.png)              | SYM_FT                     |                              | Feet symbol                           | 116        | 0x74         |
| ![Trip Distance](/resources/osd/digital/default/24x36/117.png)     | SYM_TRIP_DIST              | SYM.TRIP_DIST                | Trip distance                         | 117        | 0x75         |
| ![Total Distance](/resources/osd/digital/default/24x36/117.png)    | SYM_TOTAL                  |                              | Total distance                        | 117        | 0x75         |
| ![Alitiude Metres](/resources/osd/digital/default/24x36/118.png)   | SYM_ALT_M                  | SYM.ALT_M                    | Alitiude in Metres                    | 118        | 0x76         |
| ![Altitude Km](/resources/osd/digital/default/24x36/119.png)       | SYM_ALT_KM                 |                              | Altitude in Kilometres                | 119        | 0x77         |
| ![Altitude Ft](/resources/osd/digital/default/24x36/120.png)       | SYM_ALT_FT                 | SYM.ALT_FT                   | Altitude in Feet                      | 120        | 0x78         |
| ![Altitude kFt](/resources/osd/digital/default/24x36/121.png)      | SYM_ALT_KFT                |                              | Altitude in thousand Feet             | 121        | 0x79         |
| ![Distance Metres](/resources/osd/digital/default/24x36/122.png)   | SYM_DIST_M                 |                              | Distance in Metres                    | 122        | 0x7A         |
| ![ASCII (-)](/resources/osd/digital/default/24x36/123.png)         | _ASCII_ _*_                |                              | Bracket symbols                       | 123 - 125  | 0x7B - 0x7D  |
| ![ASCII (-)](/resources/osd/digital/default/24x36/124.png)         | _ASCII_ _*_                |                              |                                       | 124        | 0x7C         |
| ![ASCII (-)](/resources/osd/digital/default/24x36/125.png)         | _ASCII_ _*_                |                              |                                       | 125        | 0x7D         |
| ![Distance Km](/resources/osd/digital/default/24x36/126.png)       | SYM_DIST_KM                | SYM.DIST_KM                  | Distance in Kilometres                | 126        | 0x7E         |
| ![Distance Feet](/resources/osd/digital/default/24x36/127.png)     | SYM_DIST_FT                |                              | Distance in Feet                      | 127        | 0x7F         |
| ![Distance Miles](/resources/osd/digital/default/24x36/128.png)    | SYM_DIST_MI                | SYM.DIST_MI                  | Distance in Miles                     | 128        | 0x80         |
| ![Distance N Miles](/resources/osd/digital/default/24x36/129.png)  | SYM_DIST_NM                | SYM.DIST_NM                  | Distance in Nautical Miles            | 129        | 0x81         |
| ![Metres](/resources/osd/digital/default/24x36/130.png)            | SYM_M                      | SYM.M                        | Metres symbol                         | 130        | 0x82         |
| ![Kilometres](/resources/osd/digital/default/24x36/131.png)        | SYM_KM                     |                              | Kilometres symbol                     | 131        | 0x83         |
| ![Miles](/resources/osd/digital/default/24x36/132.png)             | SYM_MI                     | SYM.MI                       | Miles symbol                          | 132        | 0x84         |
| ![Nautical Miles](/resources/osd/digital/default/24x36/133.png)    | SYM_NM                     | SYM.NM                       | Nautical Miles symbol                 | 133        | 0x85         |
| ![Horiz Wind Speed](/resources/osd/digital/default/24x36/134.png)  | SYM_WIND_HORIZONTAL        | SYM.WIND_SPEED_HORIZONTAL    | Horizontal wind speed                 | 134        | 0x86         |
| ![Vert Wind Speed](/resources/osd/digital/default/24x36/135.png)   | SYM_WIND_VERTICAL          | SYM.WIND_SPEED_VERITCAL      | Vertical wind speed                   | 135        | 0x87         |
| ![3D Speed Km/h](/resources/osd/digital/default/24x36/136.png)     | SYM_3D_KMH                 | SYM.KMH_3D                   | 3D speed in Kilometres per Hour       | 136        | 0x88         |
| ![3D Speed MPH](/resources/osd/digital/default/24x36/137.png)      | SYM_3D_MPH                 | SYM.MPH_3D                   | 3D speed in Miles per Hour            | 137        | 0x89         |
| ![3D Speed Knots](/resources/osd/digital/default/24x36/138.png)    | SYM_3D_KT                  | SYM.KT_3D                    | 3D speed in Knots                     | 138        | 0x8A         |
| ![RPM](/resources/osd/digital/default/24x36/139.png)               | SYM_RPM                    | SYM.RPM                      | Revolutions per Minute symbol         | 139        | 0x8B         |
| ![Air](/resources/osd/digital/default/24x36/140.png)               | SYM_AIR                    | SYM.AIR                      | Air: Prefix for airspeed sensor       | 140        | 0x8C         |
| ![Feet per Second](/resources/osd/digital/default/24x36/141.png)   | SYM_FTS                    | SYM.FT_S                     | Feet per Second                       | 141        | 0x8D         |
| ![100 ft/min](/resources/osd/digital/default/24x36/142.png)        | SYM_100FTM                 | SYM.HUND_FTM                 | 100 Feet per Minute                   | 142        | 0x8E         |
| ![Metres/Second](/resources/osd/digital/default/24x36/143.png)     | SYM_MS                     | SYM.M_S                      | Metres per Second                     | 143        | 0x8F         |
| ![Kilometres/hour](/resources/osd/digital/default/24x36/144.png)   | SYM_KMH                    | SYM.KMH                      | Kilometres per Hour                   | 144        | 0x90         |
| ![Miles per Hour](/resources/osd/digital/default/24x36/145.png)    | SYM_MPH                    | SYM.MPH                      | Miles per Hour                        | 145        | 0x91         |
| ![Knots](/resources/osd/digital/default/24x36/146.png)             | SYM_KT                     | SYM.KT                       | Knots                                 | 146        | 0x92         |
| ![mAh/mile](/resources/osd/digital/default/24x36/147-148.png)      | SYM_MAH_MI_0               | SYM.MAH_MI_0                 | mAh per Mile, left side               | 147        | 0x93         |
|                                                                    | SYM_MAH_MI_1               | SYM.MAH_MI_1                 | mAh per Mile, right side              | 148        | 0x94         |
| ![Throttle symbol](/resources/osd/digital/default/24x36/149.png)   | SYM_THR                    | SYM.THR                      | Throttle symbol                       | 149        | 0x95         |
| ![Temp Fahrenheit](/resources/osd/digital/default/24x36/150.png)   | SYM_TEMP_F                 | SYM.TEMP_F                   | Fahrenheit symbol                     | 150        | 0x96         |
| ![Temp Celsius](/resources/osd/digital/default/24x36/151.png)      | SYM_TEMP_C                 | SYM.TEMP_C                   | Celsius symbol                        | 151        | 0x97         |
| ![Home Point map](/resources/osd/digital/default/24x36/152.png)    | _reserved or old ?_        |                              | Home point map                        | 152        | 0x98         |
| ![mAh](/resources/osd/digital/default/24x36/153.png)               | SYM_MAH                    | SYM.MAH                      | mAh sysmbol                           | 153        | 0x99         |
| ![On Hours](/resources/osd/digital/default/24x36/154.png)          | SYM_ON_H                   |                              | On hours                              | 154        | 0x9A         |
| ![Flying Hours](/resources/osd/digital/default/24x36/155.png)      | SYM_FLY_H                  |                              | Flying hours                          | 155        | 0x9B         |
| ![Glide slope](/resources/osd/digital/default/24x36/156.png)       | SYM_GLIDESLOPE             | SYM.GLIDESLOPE               | Glide slope                           | 156        | 0x9C         |
| ![Waypoint](/resources/osd/digital/default/24x36/157.png)          | SYM_WAYPOINT               |                              | Waypoint                              | 157        | 0x9D         |
| ![On Minutes](/resources/osd/digital/default/24x36/158.png)        | SYM_ON_M                   | SYM.ON_M                     | On minutes                            | 158        | 0x9E         |
| ![Flying Minutes](/resources/osd/digital/default/24x36/159.png)    | SYM_FLY_M                  | SYM.FLY_M                    | Flying minutes                        | 159        | 0x9F         |
| ![Clock](/resources/osd/digital/default/24x36/160.png)             | SYM_CLOCK                  | SYM.CLOCK                    | Clock                                 | 160        | 0xA0         |
| ![Numbers .](/resources/osd/digital/default/24x36/161.png)         | SYM_ZERO_HALF_TRAILING_DOT | SYM.ZERO_HALF_TRAILING_DOT   | Numbers with trailing dots            | 161 - 170  | 0xA1 - 0xAA  |
| ![Numbers .](/resources/osd/digital/default/24x36/162.png)         |                            |                              |                                       | 162        | 0xA2         |
| ![Numbers .](/resources/osd/digital/default/24x36/163.png)         |                            |                              |                                       | 163        | 0xA3         |
| ![Numbers .](/resources/osd/digital/default/24x36/164.png)         |                            |                              |                                       | 164        | 0xA4         |
| ![Numbers .](/resources/osd/digital/default/24x36/165.png)         |                            |                              |                                       | 165        | 0xA5         |
| ![Numbers .](/resources/osd/digital/default/24x36/166.png)         |                            |                              |                                       | 166        | 0xA6         |
| ![Numbers .](/resources/osd/digital/default/24x36/167.png)         |                            |                              |                                       | 167        | 0xA7         |
| ![Numbers .](/resources/osd/digital/default/24x36/168.png)         |                            |                              |                                       | 168        | 0xA8         |
| ![Numbers .](/resources/osd/digital/default/24x36/169.png)         |                            |                              |                                       | 169        | 0xA9         |
| ![Numbers .](/resources/osd/digital/default/24x36/170.png)         |                            |                              |                                       | 170        | 0xAA         |
| ![AutoThrottle](/resources/osd/digital/default/24x36/171-172.png)  | SYM_AUTO_THR0              |                              | Auto-throttle symbol, left side       | 171        | 0xAB         |
|                                                                    | SYM_AUTO_THR1              |                              | Auto-throttle symbol, right side      | 172        | 0xAC         |
| ![Roll Left](/resources/osd/digital/default/24x36/173.png)         | SYM_ROLL_LEFT              | SYM.ROLL_LEFT                | roll left symbol                      | 173        | 0xAD         |
| ![Roll level](/resources/osd/digital/default/24x36/174.png)        | SYM_ROLL_LEVEL             | SYM.ROLL_LEVEL               | roll level symbol                     | 174        | 0xAE         |
| ![Roll Right](/resources/osd/digital/default/24x36/175.png)        | SYM_ROLL_RIGHT             | SYM.ROLL_RIGHT               | roll right symbol                     | 175        | 0xAF         |
| ![Pitch Up](/resources/osd/digital/default/24x36/176.png)          | SYM_PITCH_UP               | SYM.PITCH_UP                 | Pitch up symbol                       | 176        | 0xB0         |
| ![. Numbers](/resources/osd/digital/default/24x36/177.png)         | SYM_ZERO_HALF_LEADING_DOT  | SYM.ZERO_HALF_LEADING_DOT    | Numbers with leading dots             | 177 - 186  | 0xB1 - 0xBA  |
| ![. Numbers](/resources/osd/digital/default/24x36/178.png)         |                            |                              |                                       | 178        | 0xB2         |
| ![. Numbers](/resources/osd/digital/default/24x36/179.png)         |                            |                              |                                       | 179        | 0xB3         |
| ![. Numbers](/resources/osd/digital/default/24x36/180.png)         |                            |                              |                                       | 180        | 0xB4         |
| ![. Numbers](/resources/osd/digital/default/24x36/181.png)         |                            |                              |                                       | 181        | 0xB5         |
| ![. Numbers](/resources/osd/digital/default/24x36/182.png)         |                            |                              |                                       | 182        | 0xB6         |
| ![. Numbers](/resources/osd/digital/default/24x36/183.png)         |                            |                              |                                       | 183        | 0xB7         |
| ![. Numbers](/resources/osd/digital/default/24x36/184.png)         |                            |                              |                                       | 184        | 0xB8         |
| ![. Numbers](/resources/osd/digital/default/24x36/185.png)         |                            |                              |                                       | 185        | 0xB9         |
| ![. Numbers](/resources/osd/digital/default/24x36/186.png)         |                            |                              |                                       | 186        | 0xBA         |
| ![Pitch Down](/resources/osd/digital/default/24x36/187.png)        | SYM_PITCH_DOWN             | SYM.PITCH_DOWN               | Pitch down symbol                     | 187        | 0xBB         |
| ![G-Force](/resources/osd/digital/default/24x36/188.png)           | SYM_GFORCE                 | SYM.GFORCE                   | Gforce (all axis)                     | 188        | 0xBC         |
| ![G-Force X](/resources/osd/digital/default/24x36/189.png)         | SYM_GFORCE_X               | SYM.GFORCE_X                 | Gforce X                              | 189        | 0xBD         |
| ![G-Force Y](/resources/osd/digital/default/24x36/190.png)         | SYM_GFORCE_Y               | SYM.GFORCE_Y                 | Gforce Y                              | 190        | 0xBE         |
| ![G-Force Z](/resources/osd/digital/default/24x36/191.png)         | SYM_GFORCE_Z               | SYM.GFORCE_Z                 | Gforce Z                              | 191        | 0xBF         |
| ![Baro temp](/resources/osd/digital/default/24x36/192.png)         | SYM_BARO_TEMP              | SYM.BARO_TEMP                | Barometer temperature                 | 192        | 0xC0         |
| ![IMU temp](/resources/osd/digital/default/24x36/193.png)          | SYM_IMU_TEMP               | SYM.IMU_TEMP                 | IMU temperature                       | 193        | 0xC1         |
| ![Temperature](/resources/osd/digital/default/24x36/194.png)       | SYM_TEMP                   | SYM.TEMP                     | Thermometer symbol **First symbol**   | 194        | 0xC2         |
| ![ESC temp](/resources/osd/digital/default/24x36/195.png)          | SYM_ESC_TEMP               | SYM.ESC_TEMPERATURE          | ESC temperature                       | 195        | 0xC3         |
| ![ESC temp](/resources/osd/digital/default/24x36/196.png)          |                            |                              |                                       | 196        | 0xC4         |
| ![ESC temp](/resources/osd/digital/default/24x36/197.png)          |                            |                              |                                       | 197        | 0xC5         |
| ![ESC temp](/resources/osd/digital/default/24x36/198.png)          |                            |                              |                                       | 198        | 0xC6         |
| ![ESC temp](/resources/osd/digital/default/24x36/199.png)          |                            |                              |                                       | 199        | 0xC7         |
| ![Heading N](/resources/osd/digital/default/24x36/200.png)         | SYM_HEADING_N              | SYM.HEADING_N                | Heading graph North                   | 200        | 0xC8         |
| ![Heading S](/resources/osd/digital/default/24x36/201.png)         | SYM_HEADING_S              | SYM.HEADING_S                | Heading graph South                   | 201        | 0xC9         |
| ![Heading E](/resources/osd/digital/default/24x36/202.png)         | SYM_HEADING_E              | SYM.HEADING_E                | Heading graph East                    | 202        | 0xCA         |
| ![Heading W](/resources/osd/digital/default/24x36/203.png)         | SYM_HEADING_W              | SYM.HEADING_W                | Heading graph West                    | 203        | 0xCB         |
| ![Heading divider](/resources/osd/digital/default/24x36/204.png)   | SYM_HEADING_DIVIDED_LINE   | SYM.HEADING_DIVIDED_LINE     | Heading graphic                       | 204        | 0xCC         |
| ![Heading line](/resources/osd/digital/default/24x36/205.png)      | SYM_HEADING_LINE           | SYM.HEADING_LINE             | Heading graphic                       | 205        | 0xCD         |
| ![Max](/resources/osd/digital/default/24x36/206.png)               | SYM_MAX                    | SYM.MAX                      | Max icon                              | 206	      | 0xCE         |
| ![Profile](/resources/osd/digital/default/24x36/207.png)           | SYM_PROFILE		          | SYM.PROFILE		             | Profile icon			                 | 207	      | 0xCF         |
| ![Switch low](/resources/osd/digital/default/24x36/208.png)        | SYM_SWITCH_INDICATOR_LOW   | N/A        		             | Switch: down                          | 208	      | 0xD0         |
| ![Switch mid](/resources/osd/digital/default/24x36/209.png)        | SYM_SWITCH_INDICATOR_LOW   | N/A        		             | Switch: middle                        | 209	      | 0xD1         |
| ![Switch high](/resources/osd/digital/default/24x36/210.png)       | SYM_SWITCH_INDICATOR_LOW   | SYM.SWITCH_INDICATOR_HIGH    | Switch: up                            | 210	      | 0xD2         |
| ![Amp hours](/resources/osd/digital/default/24x36/211.png)         | SYM_AH  		   		      | SYM.AHI    		  		     | Amp Hours icon			             | 211	      | 0xD3         |
| ![Glide distance](/resources/osd/digital/default/24x36/212.png)    | SYM_GLIDE_DIST		      | SYM.GLIDE_DIST				 | Glide Distance                        | 212        | 0xD4         |
| ![Glide time](/resources/osd/digital/default/24x36/213.png)        | SYM_GLIDE_MINS		      | SYM.GLIDE_MINS				 | Glide Time Mins                       | 213        | 0xD5         |
| ![Climb eff Ft](/resources/osd/digital/default/24x36/214-215.png)  | SYM_AH_V_FT_0              | SYM.AH_V_FT_0                | Climb efficiency: imperial L side     | 214        | 0xD6         |
|                                                                    | SYM_AH_V_FT_1              | SYM.AH_V_FT_1                | Climb efficiency: imperial R side     | 215        | 0xD7         |
| ![Climb eff M](/resources/osd/digital/default/24x36/216-217.png)   | SYM_AH_V_M_0               | SYM.AH_V_M_0                 | Climb efficiency: metric L side       | 216        | 0xD8         |
|                                                                    | SYM_AH_V_M_1               | SYM.AH_V_M_1                 | Climb efficiency: metric R side       | 217        | 0xD9         |
| ![Flight mins rem](/resources/osd/digital/default/24x36/218.png)   | SYM_FLIGHT_MINS_REMAINING  | SYM.FLIGHT_MINS_REMAINING    | Flight time (mins) remaining          | 218        | 0xDA         |
| ![Flight hours rem](/resources/osd/digital/default/24x36/219.png)  | SYM_FLIGHT_HOURS_REMAINING |                              | Flight time (hours) remaining         | 219        | 0xDB         |
| ![Ground course](/resources/osd/digital/default/24x36/220.png)     | SYM_GROUND_COURSE          | SYM.GROUND_COURSE            | Ground course                         | 220        | 0xDC         |
| ![Alert](/resources/osd/digital/default/24x36/221.png)             | SYM_ALERT                  | SYM.ALERT                    | General Alert                         | 221        | 0xDD         |
| ![Terrain follow](/resources/osd/digital/default/24x36/251.png)    | SYM_TERRAIN_FOLLOWING      | SYM.TERRAIN_FOLLOWING        | Terrain following                     | 251        | 0xFB         |
| ![Cross track err](/resources/osd/digital/default/24x36/252.png)   | SYM_CROSS_TRACK_ERROR      | SYM.CROSS_TRACK_ERROR        | Cross track error                     | 252        | 0xFC         |
| ![ADSB](/resources/osd/digital/default/24x36/253.png)              | SYM_ADSB                   | SYM.ADSB                     | ADSB                                  | 253        | 0xFD         |
| ![Blackbox](/resources/osd/digital/default/24x36/254.png)          | SYM_BLACKBOX               | SYM.BLACKBOX                 | Blackbox                              | 254        | 0xFE         |
| | | | | | |
| ![INAV Logo](/resources/osd/digital/default/24x36/257_296.png)    | SYM_LOGO_START             |                              | INAV Logo                             | 257 - 296  | 0x101 - 0x128 |
| ![AH left arrow](/resources/osd/digital/default/24x36/300.png)    | SYM_AH_LEFT                | SYM.AH_LEFT                  | AHI Arrow left                        | 300        | 0x12C         |
| ![AH right arrow](/resources/osd/digital/default/24x36/301.png)   | SYM_AH_RIGHT               | SYM.AH_RIGHT                 | AHI Arrow right                       | 301        | 0x12D         |
| ![AH scroll sides](/resources/osd/digital/default/24x36/302.png)  | SYM_AH_DECORATION_MIN      |                              | AHI Scrolling graphics                | 302 - 307  | 0x12E - 0x133 |
| ![AH scroll sides](/resources/osd/digital/default/24x36/303.png)  |                            |                              |                                       | 303        | 0x12F         |
| ![AH scroll sides](/resources/osd/digital/default/24x36/304.png)  |                            |                              |                                       | 304        | 0x130         |
| ![AH scroll sides](/resources/osd/digital/default/24x36/305.png)  | SYM_AH_DECORATION          | SYM.AH_DECORATION            | AHI Scrolling graphics                | 305        | 0x131         |
| ![AH scroll sides](/resources/osd/digital/default/24x36/306.png)  |                            |                              |                                       | 306        | 0x132         |
| ![AH scroll sides](/resources/osd/digital/default/24x36/307.png)  | SYM_AH_DECORATION_MAX      |                              | AHI Scrolling graphics                | 307        | 0x133         |
| ![Crosshair left](/resources/osd/digital/default/24x36/314.png)   | SYM_AH_CH_LEFT             | SYM.AH_CENTER_LINE           | Crosshair left                        | 314        | 0x13A         |
| ![Crosshair right](/resources/osd/digital/default/24x36/315.png)  | SYM_AH_CH_RIGHT            | SYM.AH_CENTER_LINE_RIGHT     | Crosshair right                       | 315        | 0x13B         |
| ![Dir arrow 0°](/resources/osd/digital/default/24x36/316.png)     | SYM_ARROW_UP               | SYM.DIR_TO_HOME              | Direction arrow 0°                    | 316        | 0x13C         |
| ![Dir arrow 22.5°](/resources/osd/digital/default/24x36/317.png)  | SYM_ARROW_2                |                              | Direction arrow 22.5°                 | 317        | 0x13D         |
| ![Dir arrow 45°](/resources/osd/digital/default/24x36/318.png)    | SYM_ARROW_3                |                              | Direction arrow 45°                   | 318        | 0x13E         |
| ![Dir arrow 67.5°](/resources/osd/digital/default/24x36/319.png)  | SYM_ARROW_4                |                              | Direction arrow 67.5°                 | 319        | 0x13F         |
| ![Dir arrow 90°](/resources/osd/digital/default/24x36/320.png)    | SYM_ARROW_RIGHT            |                              | Direction arrow 90°                   | 320        | 0x140         |
| ![Dir arrow 112.5°](/resources/osd/digital/default/24x36/321.png) | SYM_ARROW_6                |                              | Direction arrow 112.5°                | 321        | 0x141         |
| ![Dir arrow 135°](/resources/osd/digital/default/24x36/322.png)   | SYM_ARROW_7                |                              | Direction arrow 135°                  | 322        | 0x142         |
| ![Dir arrow 157.5°](/resources/osd/digital/default/24x36/323.png) | SYM_ARROW_8                |                              | Direction arrow 157.5°                | 323        | 0x143         |
| ![Dir arrow 180°](/resources/osd/digital/default/24x36/324.png)   | SYM_ARROW_DOWN             |                              | Direction arrow 180°                  | 324        | 0x144         |
| ![Dir arrow 202.5°](/resources/osd/digital/default/24x36/325.png) | SYM_ARROW_10               |                              | Direction arrow 202.5°                | 325        | 0x145         |
| ![Dir arrow 225°](/resources/osd/digital/default/24x36/326.png)   | SYM_ARROW_11               |                              | Direction arrow 225°                  | 326        | 0x146         |
| ![Dir arrow 247.5°](/resources/osd/digital/default/24x36/327.png) | SYM_ARROW_12               |                              | Direction arrow 247.5°                | 327        | 0x147         |
| ![Dir arrow 270°](/resources/osd/digital/default/24x36/328.png)   | SYM_ARROW_LEFT             |                              | Direction arrow 270°                  | 328        | 0x148         |
| ![Dir arrow 292.5°](/resources/osd/digital/default/24x36/329.png) | SYM_ARROW_14               |                              | Direction arrow 292.5°                | 329        | 0x149         |
| ![Dir arrow 315°](/resources/osd/digital/default/24x36/330.png)   | SYM_ARROW_15               |                              | Direction arrow 315°                  | 330        | 0x14A         |
| ![Dir arrow 337.5°](/resources/osd/digital/default/24x36/331.png) | SYM_ARROW_16               |                              | Direction arrow 337.5°                | 331        | 0x14B         |
| ![AHI](/resources/osd/digital/default/24x36/332.png)              | SYM_AH_H_START             | SYM.AH_BAR9_0                | Horizontal AHI                        | 332 - 340  | 0x14C - 0x154 |
| ![AHI](/resources/osd/digital/default/24x36/333.png)              |                            |                              | Horizontal AHI                        | 333        | 0x14D         |
| ![AHI](/resources/osd/digital/default/24x36/334.png)              |                            |                              | Horizontal AHI                        | 334        | 0x14E         |
| ![AHI](/resources/osd/digital/default/24x36/335.png)              |                            |                              | Horizontal AHI                        | 335        | 0x14F         |
| ![AHI](/resources/osd/digital/default/24x36/336.png)              |                            |                              | Horizontal AHI                        | 336        | 0x150         |
| ![AHI](/resources/osd/digital/default/24x36/337.png)              |                            |                              | Horizontal AHI                        | 337        | 0x151         |
| ![AHI](/resources/osd/digital/default/24x36/338.png)              |                            |                              | Horizontal AHI                        | 338        | 0x152         |
| ![AHI](/resources/osd/digital/default/24x36/339.png)              |                            |                              | Horizontal AHI                        | 339        | 0x153         |
| ![AHI](/resources/osd/digital/default/24x36/340.png)              |                            |                              | Horizontal AHI                        | 340        | 0x154         |
| ![Vario 2 up](/resources/osd/digital/default/24x36/341.png)       | SYM_VARIO_UP_2A            | SYM.VARIO_UP_2A              | Vario up up                           | 341        | 0x155         |
| ![Vario 1 up](/resources/osd/digital/default/24x36/342.png)       | SYM_VARIO_UP_1A            |                              | Vario up                              | 342        | 0x156         |
| ![Vario 1 down](/resources/osd/digital/default/24x36/343.png)     | SYM_VARIO_DOWN_1A          |                              | Vario down                            | 343        | 0x157         |
| ![Vario 2 down](/resources/osd/digital/default/24x36/344.png)     | SYM_VARIO_DOWN_2A          |                              | Vario down down                       | 344        | 0x158         |
| ![Altitude](/resources/osd/digital/default/24x36/345.png)         | SYM_ALT                    |                              | Altitude symbol                       | 345        | 0x159         |
| ![Vertical AHI](/resources/osd/digital/default/24x36/346.png)     | SYM_AH_V_START             |                              | Vertical AHI                          | 346 - 351  | 0x15A - 0x159 |
| ![Vertical AHI](/resources/osd/digital/default/24x36/347.png)     |                            |                              |                                       | 347        | 0x15B         |
| ![Vertical AHI](/resources/osd/digital/default/24x36/348.png)     |                            |                              |                                       | 348        | 0x15C         |
| ![Vertical AHI](/resources/osd/digital/default/24x36/349.png)     |                            |                              |                                       | 349        | 0x15D         |
| ![Vertical AHI](/resources/osd/digital/default/24x36/350.png)     |                            |                              |                                       | 350        | 0x15E         |
| ![Vertical AHI](/resources/osd/digital/default/24x36/351.png)     |                            |                              |                                       | 351        | 0x15F         |
| ![HUD Signal lost](/resources/osd/digital/default/24x36/352.png)  | SYM_HUD_SIGNAL_0           |                              | HUD signal lost icon                  | 352        | 0x160         |
| ![HUD Signal 25%](/resources/osd/digital/default/24x36/353.png)   | SYM_HUD_SIGNAL_1           |                              | HUD signal 25% icon                   | 353        | 0x161         |
| ![HUD Signal 50%](/resources/osd/digital/default/24x36/354.png)   | SYM_HUD_SIGNAL_2           |                              | HUD signal 50% icon                   | 354        | 0x162         |
| ![HUD Signal 75%](/resources/osd/digital/default/24x36/355.png)   | SYM_HUD_SIGNAL_3           |                              | HUD signal 75% icon                   | 355        | 0x163         |
| ![HUD Signal 100%](/resources/osd/digital/default/24x36/356.png)  | SYM_HUD_SIGNAL_4           |                              | HUD signal 100% icon                  | 356        | 0x164         |
| ![Home distance](/resources/osd/digital/default/24x36/357.png)    | SYM_HOME_DIST              |                              | Home distance icon                    | 357        | 0x165         |
| ![Crosshair centre](/resources/osd/digital/default/24x36/358.png) | SYM_AH_CH_CENTER           | SYM.AH_CROSSHAIRS            | Default crosshair centre              | 358        | 0x166         |
| ![Flight dist rem](/resources/osd/digital/default/24x36/359.png)  | SYM_FLIGHT_DIST_REMAINING  | SYM.FLIGHT_DIST_REMAINING    | Flight distance remaining             | 359        | 0x167         |
| ![Odometer](/resources/osd/digital/default/24x36/360.png)         | SYM_ODOMETER               | SYM.ODOMETER                 | Odometer (total aircraft distance)    | 360        | 0x168         |
| ![RX Band](/resources/osd/digital/default/24x36/361.png)          | SYM_RX_BAND                | SYM.RX_BAND                  | Frequency band used by RX             | 361        | 0x169         |
| ![RX Mode](/resources/osd/digital/default/24x36/362.png)          | SYM_RX_MODE                | SYM.RX_MODE                  | Mode used by RX (150HZ for example)   | 362        | 0x16A         |
| ![Crosshair 3](/resources/osd/digital/default/24x36/400_402.png)  | SYM_AH_CH_TYPE3            | SYM.AH_CROSSHAIRS            | Crosshair type 3                      | 400 - 402  | 0x190 - 0x192 |
| ![Crosshair 4](/resources/osd/digital/default/24x36/403_405.png)  | SYM_AH_CH_TYPE4            | SYM.AH_CROSSHAIRS            | Crosshair type 4                      | 403 - 405  | 0x193 - 0x195 |
| ![Crosshair 5](/resources/osd/digital/default/24x36/406_408.png)  | SYM_AH_CH_TYPE5            | SYM.AH_CROSSHAIRS            | Crosshair type 5                      | 406 - 408  | 0x196 - 0x198 |
| ![Crosshair 6](/resources/osd/digital/default/24x36/409_411.png)  | SYM_AH_CH_TYPE6            | SYM.AH_CROSSHAIRS            | Crosshair type 6                      | 409 - 411  | 0x199 - 0x19B |
| ![Crosshair 7](/resources/osd/digital/default/24x36/412_414.png)  | SYM_AH_CH_TYPE7            | SYM.AH_CROSSHAIRS            | Crosshair type 7                      | 412 - 414  | 0x19C - 0x19E |
| ![Crosshair 8](/resources/osd/digital/default/24x36/415_417.png)  | SYM_AH_CH_TYPE8            | SYM.AH_CROSSHAIRS            | Crosshair type 8                      | 415 - 417  | 0x19F - 0x1A1 |
| ![Crosshair 9](/resources/osd/digital/default/24x36/418_422.png)  | SYM_AH_CH_AIRCRAFT0        | SYM.AH_AIRCRAFT0             | Aircraft crosshair left               | 418        | 0x1A2         |
|                                                                   | SYM_AH_CH_AIRCRAFT1        | SYM.AH_AIRCRAFT1             | Aircraft crosshair                    | 419        | 0x1A3         |
|                                                                   | SYM_AH_CH_AIRCRAFT2        | SYM.AH_AIRCRAFT2             | Aircraft crosshair centre             | 420        | 0x1A4         |
|                                                                   | SYM_AH_CH_AIRCRAFT3        | SYM.AH_AIRCRAFT3             | Aircraft crosshair                    | 421        | 0x1A5         |
|                                                                   | SYM_AH_CH_AIRCRAFT4        | SYM.AH_AIRCRAFT4             | Aircraft crosshair right              | 422        | 0x1A6         |
| ![HUD Arrows L1](/resources/osd/digital/default/24x36/430.png)    | SYM_HUD_ARROWS_L1          |                              | 1 arrow left                          | 430        | 0x1AE         |
| ![HUD Arrows L2](/resources/osd/digital/default/24x36/431.png)    | SYM_HUD_ARROWS_L2          |                              | 2 arrows left                         | 431        | 0x1AF         |
| ![HUD Arrows L3](/resources/osd/digital/default/24x36/432.png)    | SYM_HUD_ARROWS_L3          |                              | 3 arrows left                         | 432        | 0x1B0         |
| ![HUD Arrows R1](/resources/osd/digital/default/24x36/433.png)    | SYM_HUD_ARROWS_R1          |                              | 1 arrow right                         | 433        | 0x1B1         |
| ![HUD Arrows R2](/resources/osd/digital/default/24x36/434.png)    | SYM_HUD_ARROWS_R2          |                              | 2 arrows right                        | 434        | 0x1B2         |
| ![HUD Arrows R3](/resources/osd/digital/default/24x36/435.png)    | SYM_HUD_ARROWS_R3          |                              | 3 arrows right                        | 435        | 0x1B3         |
| ![HUD Arrows U1](/resources/osd/digital/default/24x36/436.png)    | SYM_HUD_ARROWS_U1          |                              | 1 arrow up                            | 436        | 0x1B4         |
| ![HUD Arrows U2](/resources/osd/digital/default/24x36/437.png)    | SYM_HUD_ARROWS_U2          |                              | 2 arrows up                           | 437        | 0x1B5         |
| ![HUD Arrows U3](/resources/osd/digital/default/24x36/438.png)    | SYM_HUD_ARROWS_U3          |                              | 3 arrows up                           | 438        | 0x1B6         |
| ![HUD Arrows D1](/resources/osd/digital/default/24x36/439.png)    | SYM_HUD_ARROWS_D1          |                              | 1 arrow down                          | 439        | 0x1B7         |
| ![HUD Arrows D2](/resources/osd/digital/default/24x36/440.png)    | SYM_HUD_ARROWS_D2          |                              | 2 arrows down                         | 440        | 0x1B8         |
| ![HUD Arrows D3](/resources/osd/digital/default/24x36/441.png)    | SYM_HUD_ARROWS_D3          |                              | 3 arrows down                         | 441        | 0x1B9         |
| ![Cardinal S](/resources/osd/digital/default/24x36/442.png)       | SYM_HUD_CARDINAL           |                              | Cardinal indicators                   | 442 - 453  | 0x1BA - 0x1C5 |
| ![Cardinal S](/resources/osd/digital/default/24x36/443.png)       |                            |                              |                                       | 443        | 0x1BB         |
| ![Cardinal S](/resources/osd/digital/default/24x36/444.png)       |                            |                              |                                       | 444        | 0x1BC         |
| ![Cardinal S](/resources/osd/digital/default/24x36/445.png)       |                            |                              |                                       | 445        | 0x1BD         |
| ![Cardinal S](/resources/osd/digital/default/24x36/446.png)       |                            |                              |                                       | 446        | 0x1BE         |
| ![Cardinal S](/resources/osd/digital/default/24x36/447.png)       |                            |                              |                                       | 447        | 0x1BF         |
| ![Cardinal S](/resources/osd/digital/default/24x36/448.png)       |                            |                              |                                       | 448        | 0x1C0         |
| ![Cardinal S](/resources/osd/digital/default/24x36/449.png)       |                            |                              |                                       | 449        | 0x1C1         |
| ![Cardinal S](/resources/osd/digital/default/24x36/450.png)       |                            |                              |                                       | 450        | 0x1C2         |
| ![Cardinal S](/resources/osd/digital/default/24x36/451.png)       |                            |                              |                                       | 451        | 0x1C3         |
| ![Cardinal S](/resources/osd/digital/default/24x36/452.png)       |                            |                              |                                       | 452        | 0x1C4         |
| ![Cardinal S](/resources/osd/digital/default/24x36/453.png)       |                            |                              |                                       | 453        | 0x1C5         |
| ![Pan centred](/resources/osd/digital/default/24x36/454.png)      | SYM_SERVO_PAN_IS_CENTRED   |                              | Pan servo is centred                  | 454        | 0x1C6         |
| ![Pan Left](/resources/osd/digital/default/24x36/455.png)         | SYM_SERVO_PAN_IS_OFFSET_L  | SYM.PAN_SERVO_IS_OFFSET_L    | Pan servo is moved to the left        | 455        | 0x1C7         |
| ![Pan Right](/resources/osd/digital/default/24x36/456.png)        | SYM_SERVO_PAN_IS_OFFSET_R  |                              | Pan servo is moved to the right       | 456        | 0x1C8         |
| ![Pilot Logo S](/resources/osd/digital/default/24x36/469_471.png) | SYM_PILOT_LOGO_SML_L       | SYM.PILOT_LOGO_SML_L         | Small Pilot logo                      | 469 - 471  | 0x1D5 - 0x1D7 |
| ![Pilot Logo L](/resources/osd/digital/default/24x36/472_511.png) | SYM_PILOT_LOGO_LRG_START   |                              | Large Pilot logo                      | 472 - 511  | 0x1D5 - 0x1D7 |

_*_ Do not change the IDs of these characters
